function Mi0 = get_Mi0(i)

% Computes M_i0 for a given i. The belief set Mi0 is represented 
% in the usual way.

%-------
% setup
%-------

% global

global beta plr Pr_data x_data n NA NY NW jstate

% local

x_i = zeros(NW(i),NW(n(i)));

%-------------
% computation
%-------------

% get x_i 

switch i
  
 case(1)
  
  for si=1:NW(1); for sni=1:NW(2)
      
      x_i(si,sni) = x_data(si,sni);
      
  end; end
    
 case(2)
  
  for si=1:NW(2); for sni=1:NW(1)
      
      x_i(si,sni) = x_data(sni,si);
      
  end; end
 
end

% get Mi0

Mi0(NW(i)) = struct;

for wi=1:NW(i)
    
    % first get ext_cand
    
    ext_cand = [];
    
    for si=1:NW(i)
        
        if (plr(i).w0(si)==wi) % m_{i0}(si) is an ext pt candidate
            
          m_i = zeros(1,NW(n(i)));
                      
          for wni=1:NW(n(i)); for sni=1:NW(n(i))
              
              if (plr(n(i)).w0(sni)==wni)
                m_i(wni) = m_i(wni) + x_i(si,sni);
              end
              
          end; end
          
          m_i = m_i./sum(x_i(si,:)); % n.b. using x_i>>0
          
          ext_cand = [ext_cand;m_i];
                        
        end
        
    end
    
    % set elements of Mi0
    
    if (size(ext_cand,1)==0)
      
      Mi0(wi).emp = 1;
      Mi0(wi).ext = NaN;
  
    else 
      
      Mi0(wi).emp = 0;
      Mi0(wi).ext = extblfs(ext_cand);
  
    end
    
end

  

